create or replace package body tbicds.PCK_SYSTEM_ID is
/* Copyright 2015 Intellica Corporation 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
    http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
  /*This function will return a person id string*/
  function GetNewPersonID return varchar2 
  is
    v_vPatientID varchar2(72) := '';
    v_vPadding   varchar2(12) := '00000000';
  begin
    -- build the Patient ID
    v_vPatientID := v_vPatientID || c_vPatient;
    v_vPatientID := v_vPatientID || GenerateRandomString(6);
    v_vPatientID := v_vPatientID || GetDateTimeString;
    return v_vPatientID;
  end;

  /*This function will return a patient id string*/
  function GetNewPatientID(pi_vFirstName   in varchar2,
                           pi_vLastName    in varchar2,
                           pi_vDateOfBirth in varchar2,
                           pi_vGender      in varchar2,
                           pi_vSSN         in varchar2) return varchar2 
  is
  
    v_vPatientID varchar2(72) := '';
    v_vPadding   varchar2(12) := '00000000';
  
  begin
  
    -- build the Patient ID
    v_vPatientID := v_vPatientID || c_vPatient;
    v_vPatientID := v_vPatientID || GenerateRandomString(6);
    v_vPatientID := v_vPatientID || GetDateTimeString;
  
    return v_vPatientID;
  
  end;
  
  /*This function will return a provider id string*/
  function GetNewProviderID(pi_vFirstName   in varchar2,
                           pi_vLastName    in varchar2) return varchar2 is
  
    v_vProviderID varchar2(72) := '';
    v_vPadding   varchar2(12) := '00000000';
  
  begin
  
    -- build the Patient ID
    v_vProviderID := v_vProviderID || c_vProvider;
    v_vProviderID := v_vProviderID || GenerateRandomString(6);
    v_vProviderID := v_vProviderID || GetDateTimeString;
  
    return v_vProviderID;
  
  end;
  

  /*This function will return a provider id string*/
  function GetNewProviderID(pi_vFirstName in varchar2,
                            pi_vLastName  in varchar2,
                            pi_vNPI       in varchar2) return varchar2 
  is
  
    v_nPadLength number := 7;
    v_vPadding   varchar2(24) := '000000000000000000000000';
    v_vNPI       varchar2(24) := '';
    v_vNPISuffix varchar2(8) := '_NO_NPI';
  
    v_vProviderID varchar2(72) := '';
  
  begin
  
    --if  provider does not have NPI
    if ((pi_vNPI is null) OR (length(pi_vNPI) < 1)) then
      v_nPadLength := 14;
    else
      v_vNPI       := pi_vNPI;
      v_vNPISuffix := substr(v_vNPISuffix, -4);
    end if;
  
    v_vProviderID := v_vProviderID || c_vProvider || v_vNPISuffix;
    v_vProviderID := v_vProviderID || GenerateRandomString(6);
    v_vProviderID := v_vProviderID || GetDateTimeString;
    v_vProviderID := v_vProviderID ||
                     FromStringToNumber(substr(upper(pi_vFirstName ||
                                                     'AAAA'),
                                               1,
                                               4),
                                        2);
    v_vProviderID := v_vProviderID ||
                     FromStringToNumber(substr(upper(pi_vLastName || 'AAAA'),
                                               1,
                                               4),
                                        2);
    v_vProviderID := v_vProviderID || v_vNPI;
    v_vProviderID := v_vProviderID ||
                     substr(v_vPadding, (v_nPadLength * -1));
  
    return v_vProviderID;
  
  end;

  /* This function will return a contact patient id*/
  function GetNewContactPatientID(pi_vPatientID in varchar2) return varchar2 
  is
    v_vContactID varchar2(72) := '';
  begin
    v_vContactID := v_vContactID || c_vContact;
    v_vContactID := v_vContactID || substr(pi_vPatientID, 4);
    return v_vContactID;
  end;

  /*This function is used to return a numerical representation 
   of the alpha characters passed on.
   Where A=0 and Z=25
   The length of the returned value 
   for each character can be from 1 to 10 */
  function FromStringToNumber(pi_vString in varchar2, pi_nLength in number)
    return varchar2 
  is
  
    v_vResult  varchar2(32767) := '';
    v_vLetter  varchar2(1) := '';
    v_nCounter number;
    v_nASCII   number;
    v_nOffset  number := 65; --ASCII value for A is 65, we want the conversion starting at 0
    v_vPadding varchar2(10) := '0000000000';
  
  begin
  
    if length(pi_vString) > 0 then
      for v_nCounter in 1 .. length(pi_vString) loop
        v_vLetter := substr(upper(pi_vString), v_nCounter, 1);
        v_nASCII  := to_number(ic_utl_sec.VarcharToAscii(v_vLetter)) -
                     v_nOffset;
        v_vResult := v_vResult || substr(v_vPadding || to_char(v_nASCII),
                                         (pi_nLength * -1));
      
      end loop;
    end if;
    return v_vResult;
  end;

  /* This function is used to convert digits passed on to alpha characters
     Where 0 = A and 9 = J */
  function FromNumberToString(pi_vNumber in varchar2) return varchar2 
  
  is
  
    v_vResult  varchar2(32767) := '';
    v_vNumber  varchar2(1) := '';
    v_nNumber  number;
    v_nCounter number;
    v_nOffset  number := 65; --ASCII value for A is 65, we want the conversion starting at 0
  
  begin
  
    if length(pi_vNumber) > 0 then
      for v_nCounter in 1 .. length(pi_vNumber) loop
        v_vNumber := substr(upper(pi_vNumber), v_nCounter, 1);
        v_nNumber := to_number(v_vNumber) + v_nOffset;
        v_vResult := v_vResult || chr(v_nNumber);
      end loop;
    end if;
    return v_vResult;
  end;

  /* This function will generate a random alphanumeric characters string of N-Length*/
  function GenerateRandomString(pi_nLength in number) return varchar2 
  is
    v_vRandomChars raw(255);
    v_vResults     varchar2(255) := '';
  begin
    v_vRandomChars := dbms_crypto.randombytes(ceil(pi_nLength / 2));
    v_vResults     := v_vResults || v_vRandomChars;
    return v_vResults;
  end;

  /*
  This function will return a datetime string to the second resolution
  */
  function GetDateTimeString return varchar2 is
    v_vResults varchar2(24) := '';
  begin
    v_vResults := v_vResults || to_char(sysdate, 'mmddyyyyHHMMSS');
    return v_vResults;
  end;

end;
/

